package com.qboxus.tictic.activitesfragments.profile.settings

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.activity.result.ActivityResult
import androidx.activity.result.ActivityResultCallback
import androidx.activity.result.contract.ActivityResultContracts
import androidx.databinding.DataBindingUtil
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.accounts.PhoneVarificationActivity
import com.qboxus.tictic.databinding.ActivityManageProfileBinding
import com.qboxus.tictic.simpleclasses.AppCompatLocaleActivity
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Functions.getSharedPreference
import com.qboxus.tictic.simpleclasses.Functions.setLocale
import com.qboxus.tictic.simpleclasses.Variables

class ManageProfileActivity : AppCompatLocaleActivity(), View.OnClickListener {

    var binding:ActivityManageProfileBinding?=null
    var resultCallback = registerForActivityResult<Intent, ActivityResult>(
        ActivityResultContracts.StartActivityForResult(), object : ActivityResultCallback<ActivityResult?> {

            override fun onActivityResult(result: ActivityResult?) {
                if (result?.resultCode == RESULT_OK) {
                    val data = result.data
                    if (data!!.getBooleanExtra("isShow", false)) {
                        setUpScreenData()
                    }
                }
            }
        })

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setLocale(
            getSharedPreference(this@ManageProfileActivity).getString(
                Variables.APP_LANGUAGE_CODE,
                Variables.DEFAULT_LANGUAGE_CODE
            ), this, javaClass, false
        )
        binding=DataBindingUtil.setContentView(this,R.layout.activity_manage_profile)

        InitControl()
    }

    private fun InitControl() {
        binding?.tabDeleteAccount?.setOnClickListener(this)
        binding?.backBtn?.setOnClickListener(this)
        binding?.tabChangePhoneNo?.setOnClickListener(this)
        binding?.tabChangePassword?.setOnClickListener(this)
        setUpScreenData()
    }

    private fun setUpScreenData() {

        var phone=getSharedPreference(this).getString(Variables.U_PHONE_NO, "")
        var email=getSharedPreference(this).getString(Variables.U_EMAIL, "")


        if (getSharedPreference(this).getString(Variables.U_SOCIAL, "") == "email") {

            binding?.tabEmail!!.visibility=View.VISIBLE
            binding?.tvemail!!.text=email

            if(Functions.isStringHasValue(phone)){
                binding?.tabChangePhoneNo!!.visibility = View.VISIBLE
                binding?.tvPhoneNo!!.text = phone
            }

            binding?.tabChangePassword!!.visibility = View.VISIBLE

        }

        else if(getSharedPreference(this).getString(Variables.U_SOCIAL, "") == "google"){
            binding?.tabEmail!!.visibility=View.VISIBLE
            binding?.tvemail!!.text= getSharedPreference(this).getString(Variables.U_EMAIL,"")

            if(Functions.isStringHasValue(phone)){
                binding?.tabChangePhoneNo!!.visibility = View.VISIBLE
                binding?.tvPhoneNo!!.text = phone
            }
        }

        else if (getSharedPreference(this).getString(Variables.U_SOCIAL, "") == "phone") {

            binding?.tabChangePhoneNo!!.visibility = View.VISIBLE
            binding?.tvPhoneNo!!.text = phone

            if(Functions.isStringHasValue(email)){
                binding?.tabEmail!!.visibility = View.VISIBLE
                binding?.tvemail!!.text = email
            }
        }

    }

    override fun onClick(view: View) {
        when (view.id) {
            R.id.tabDeleteAccount -> {
                startActivity(Intent(this@ManageProfileActivity, DeleteAccountActivity::class.java))
                overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
            }

            R.id.tabChangePhoneNo -> {
                val intent = Intent(this@ManageProfileActivity, PhoneVarificationActivity::class.java)
                intent.putExtra("type", "change")
                resultCallback.launch(intent)
                overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
            }

            R.id.tabChangePassword -> {
                startActivity(Intent(this@ManageProfileActivity, ChangePasswordActivity::class.java))
                overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
            }

            R.id.back_btn -> {
                onBackPressed()
            }
        }
    }
}